<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:param name="Local">local</xsl:param>
<xsl:param name="ImgPath">../js</xsl:param>
<xsl:param name="lang">en</xsl:param>
<xsl:template match="/">
<!-- Build = 2006.03.22 -->
<html>
<div id="region">
	<xsl:for-each select="/JVCSM/UL/*">
		<xsl:if test="name() = 'LI'">
			<div>
				<xsl:if test="not (OBJECT/param[@name='ImageNumber']/@value != '')">
					<xsl:attribute name="class">ttl1</xsl:attribute>
					<xsl:call-template name="insImg"/>
				</xsl:if>
				<xsl:if test="(OBJECT/param[@name='ImageNumber']/@value != '')">
					<xsl:attribute name="class">ttl0</xsl:attribute>
				</xsl:if>
				<xsl:call-template name="title"/>
			</div>
		</xsl:if>
		<xsl:if test="name() = 'UL'">
			<div style='display:block;'>
				<xsl:attribute name="id">
					<xsl:number level="any" count="/JVCSM/UL/LI" />
				</xsl:attribute>
				<xsl:for-each select="LI">
					<div class="ttl2"><xsl:call-template name="title"/></div>
				</xsl:for-each>
			</div>
		</xsl:if>
	</xsl:for-each>
</div>
</html>
</xsl:template>

<xsl:template name="insImg">
	<img align='absmiddle' hspace='5' onmouseover="this.style.cursor='pointer';">
		<xsl:attribute name="src">
			<xsl:value-of select="$ImgPath" />/fg1.gif
		</xsl:attribute>
		<xsl:attribute name="id">
			<xsl:variable name="num">
				<xsl:number level="any" count="/JVCSM/UL/LI" />
			</xsl:variable>
			<xsl:value-of select="concat('nd', $num)" />
		</xsl:attribute>
		<xsl:attribute name="onclick">
			ViewTree(<xsl:number level="any" count="/JVCSM/UL/LI" />);
		</xsl:attribute>
	</img>
</xsl:template>

<xsl:template name="title">
	<xsl:if test="(OBJECT/param[@name=$Local]/@value != '')">
		<xsl:if test="contains(OBJECT/param[@name=$Local]/@value, 'JavaScript:')">
			<span style="background:white">
				<xsl:attribute name="class">
					<xsl:value-of select="OBJECT/param[@name='Name']/@id" />
				</xsl:attribute>
				<a>
					<xsl:attribute name="href">
						<xsl:value-of select="OBJECT/param[@name=$Local]/@value" />
					</xsl:attribute>
					<xsl:attribute name="title">
						<xsl:value-of select="OBJECT/param[@name='Name']/@value" />
					</xsl:attribute>
					<xsl:value-of select="OBJECT/param[@name='Name']/@value" />
				</a>
			</span>
		</xsl:if>
		<xsl:if test="not (contains(OBJECT/param[@name=$Local]/@value, 'JavaScript:'))">
			<a>
				<xsl:attribute name="href">
					<xsl:value-of select="OBJECT/param[@name=$Local]/@value" />
				</xsl:attribute>
				<xsl:attribute name="title">
					<xsl:if test="//JVCSM/@LANG != 'JAPANESE'">
						<xsl:value-of select="OBJECT/param[@name='Name']/@value" />
					</xsl:if>
					<xsl:if test="//JVCSM/@LANG = 'JAPANESE'">
						<xsl:if test="starts-with(OBJECT/param[@name='Name']/@value, 'Cover Page')">表紙</xsl:if>
						<xsl:if test="not(starts-with(OBJECT/param[@name='Name']/@value, 'Cover Page'))">
							<xsl:value-of select="OBJECT/param[@name='Name']/@value" />
						</xsl:if>
					</xsl:if>
				</xsl:attribute>
				<xsl:attribute name="target">
					<xsl:value-of select="OBJECT/param[@name='FrameName']/@value" />
				</xsl:attribute>
				<xsl:if test="//JVCSM/@LANG != 'JAPANESE'">
					<xsl:value-of select="OBJECT/param[@name='Name']/@value" />
				</xsl:if>
				<xsl:if test="//JVCSM/@LANG = 'JAPANESE'">
					<xsl:if test="starts-with(OBJECT/param[@name='Name']/@value, 'Cover Page')">表紙</xsl:if>
					<xsl:if test="not(starts-with(OBJECT/param[@name='Name']/@value, 'Cover Page'))">
						<xsl:value-of select="OBJECT/param[@name='Name']/@value" />
					</xsl:if>
				</xsl:if>
			</a>
		</xsl:if>
	</xsl:if>
	<xsl:if test="not (OBJECT/param[@name=$Local]/@value != '')">
			<xsl:value-of select="OBJECT/param[@name='Name']/@value" />
	</xsl:if>
</xsl:template>

</xsl:stylesheet>
